/*
 * Decompiled with CFR 0.152.
 */
package becker.robots;

import becker.robots.City;
import becker.robots.Direction;
import becker.robots.IColor;
import becker.robots.IIterate;
import becker.robots.ILabel;
import becker.robots.IPredicate;
import becker.robots.Intersection;
import becker.robots.Light;
import becker.robots.RobotException;
import becker.robots.Sim;
import becker.robots.SimBag;
import becker.robots.StateChangeEvent;
import becker.robots.StateChangeEventType;
import becker.robots.Thing;
import becker.robots.ad;
import becker.robots.am;
import becker.robots.icons.BrokenIcon;
import becker.robots.icons.RobotIcon;
import becker.robots.w;
import becker.robots.y;
import becker.util.IObserver;
import becker.util.Utilities;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Robot
extends Sim
implements IColor,
ILabel {
    private Direction a;
    private double b = 0.0;
    private double c = 2.0;
    private boolean d;
    private SimBag e = new SimBag();

    public Robot(City city, int n2, int n3, Direction direction) {
        this(city, n2, n3, direction, 0);
    }

    public Robot(City city, int n2, int n3, Direction direction, int n4) {
        super(city, n2, n3, direction, new RobotIcon(w.c("ROBOT_COLOR")));
        if (!direction.d()) {
            throw new IllegalArgumentException("Precondition: direction in {Direction.NORTH, SOUTH, EAST, WEST}.");
        }
        this.a = direction;
        a a2 = new a(this);
        city.c().addObserver(a2);
        a2.update(city.c(), null);
        for (int i2 = 0; i2 < n4; ++i2) {
            this.makeThing(i2, n4);
        }
        this.getIntersection().addSim(this);
    }

    public synchronized void move() {
        if (!this.a()) {
            return;
        }
        Intersection intersection = this.getIntersection();
        Intersection intersection2 = intersection.getNeighbor(this.getDirection());
        if (!this.frontIsClear()) {
            this.breakRobot("A robot at (" + this.getStreet() + ", " + this.getAvenue() + ") crashed while moving " + (Object)((Object)this.getDirection()) + ".");
            return;
        }
        intersection.removeSim(this);
        this.a(intersection2.b() - intersection.b(), intersection2.c() - intersection.c());
        intersection2.addSim(this);
    }

    public synchronized void turnLeft() {
        this.a(this.a, this.a.left());
    }

    public void pickThing() {
        this.pickThing(IPredicate.canBeCarried);
    }

    public void putThing() {
        this.putThing(IPredicate.anyThing);
    }

    public boolean canPickThing() {
        return this.examineThings(IPredicate.canBeCarried).hasNext();
    }

    public boolean frontIsClear() {
        Intersection intersection = this.getIntersection();
        if (intersection.exitIsBlocked(this.getDirection())) {
            return false;
        }
        return !(intersection = intersection.getNeighbor(this.getDirection())).entryIsBlocked(this.a.opposite());
    }

    public int getAvenue() {
        return (int)Math.round(super.b());
    }

    public int getStreet() {
        return (int)Math.round(super.c());
    }

    public Direction getDirection() {
        return Direction.a(this.d());
    }

    public int countThingsInBackpack() {
        return this.e.a();
    }

    public double getSpeed() {
        return this.c;
    }

    public void setSpeed(double d2) {
        this.c = d2;
    }

    @Override
    public void setTransparency(double d2) {
        this.getIcon().setTransparency(d2);
        this.notifyObservers(new StateChangeEvent(StateChangeEventType.COLOR, this));
    }

    @Override
    public double getTransparency() {
        return this.getIcon().getTransparency();
    }

    @Override
    public String getLabel() {
        if ((object = ((Sim)object).getIcon()) instanceof ILabel) {
            Object object = (ILabel)object;
            return object.getLabel();
        }
        return "";
    }

    @Override
    public void setLabel(String string) {
        this.getIcon().setLabel(string);
        this.notifyObservers(new StateChangeEvent(StateChangeEventType.LABEL, this));
    }

    @Override
    public Intersection getIntersection() {
        return super.getCity().getIntersection(this.getStreet(), this.getAvenue());
    }

    public void pickThing(IPredicate object) {
        try {
            object = (Thing)this.getIntersection().examineThings((IPredicate)object).next();
            this.pickThing((Thing)object);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.breakRobot("A robot at (" + this.getStreet() + ", " + this.getAvenue() + ") tried to pick up a thing when nothing that can be carried was present.");
            return;
        }
    }

    public void pickThing(Thing thing) {
        if (!this.a()) {
            return;
        }
        if (thing != null && thing.canBeCarried()) {
            double d2 = this.getIcon().getSize();
            this.getIcon().setSize(Math.min(d2 * 1.15, 1.0));
            Utilities.sleep((int)(1000.0 / this.c / 6.0 * this.b));
            this.getIntersection().removeSim(thing);
            thing.a(this);
            this.e.a(thing);
            this.getIcon().setSize(d2);
            Utilities.sleep((int)(1000.0 / this.c / 6.0 * this.b));
            return;
        }
        this.breakRobot("A robot at (" + this.getStreet() + ", " + this.getAvenue() + ") tried to pick up a thing when nothing that can be carried was present.");
    }

    public void putThing(IPredicate object) {
        if (!this.a()) {
            return;
        }
        if ((object = (Thing)this.e.b((IPredicate)object)) == null) {
            if (this.e.a() == 0) {
                this.breakRobot("A robot at (" + this.getStreet() + ", " + this.getAvenue() + ") tried to put a thing down when its backpack was empty.");
                return;
            }
            this.breakRobot("A robot at (" + this.getStreet() + ", " + this.getAvenue() + ") tried to put a thing down when its backpack didn't contain a thing " + "matched by the provided predicate.");
            return;
        }
        double d2 = this.getIcon().getSize();
        this.getIcon().setSize(d2 * 0.85);
        Utilities.sleep((int)(1000.0 / this.c / 6.0 * this.b));
        this.e.b((Sim)object);
        this.getIntersection().addSim((Sim)object);
        this.getIcon().setSize(d2);
        Utilities.sleep((int)(1000.0 / this.c / 6.0 * this.b));
    }

    public void putThing(Thing thing) {
        if (!this.a()) {
            return;
        }
        if (this.e.b(thing)) {
            this.getIntersection().addSim(thing);
            return;
        }
        this.breakRobot("A robot at (" + this.getStreet() + ", " + this.getAvenue() + ") tried to put down a specific thing, but the thing was not in its backpack.");
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + "street=" + this.getStreet() + ", avenue=" + this.getAvenue() + ", direction=" + (Object)((Object)this.getDirection()) + ", isBroken=" + this.d + ", numThingsInBackpack=" + this.e.a() + "]";
    }

    public final IIterate<Robot> examineRobots() {
        am am2 = new am(this);
        return this.getIntersection().examineRobots(am2);
    }

    public final IIterate<Light> examineLights() {
        return this.getIntersection().examineLights(IPredicate.anyLight);
    }

    public final IIterate<Thing> examineThings() {
        return this.getIntersection().examineThings();
    }

    public final IIterate<Thing> examineThings(IPredicate iPredicate) {
        return this.getIntersection().examineThings(iPredicate);
    }

    public boolean isBesideThing(IPredicate iPredicate) {
        return this.examineThings(iPredicate).hasNext();
    }

    public int countThingsInBackpack(IPredicate iPredicate) {
        return this.e.a(iPredicate);
    }

    protected void save(String string, PrintWriter printWriter) {
        printWriter.print(string + this.getClass().getName() + " ");
        printWriter.print(this.getStreet() + " ");
        printWriter.print(this.getAvenue() + " ");
        printWriter.print((Object)((Object)this.getDirection()) + " ");
        printWriter.print(this.countThingsInBackpack() + " ");
    }

    protected Thing makeThing(int n2, int n3) {
        return new Thing(this);
    }

    protected void breakRobot(String string) {
        if (!this.d) {
            this.d = true;
            this.setIcon(new BrokenIcon(this.getIcon()));
            throw new RobotException(string);
        }
    }

    private void a(double d2, double d3) {
        y y2;
        y y3;
        y y4 = y3 = this.e();
        this.notifyObservers(new StateChangeEvent(StateChangeEventType.BEGIN_MOVING, this, y3, y4));
        long l2 = (long)(1000.0 / this.c * this.b) / 8L;
        double d4 = d2 / 8.0;
        double d5 = d3 / 8.0;
        for (int i2 = 0; i2 < 8; ++i2) {
            y3 = y4;
            double d6 = 0.0;
            double d7 = d5;
            double d8 = d4;
            y2 = y3;
            y4 = new y(y2.a + d8, y2.b + d7, y2.c);
            super.a(y4);
            this.notifyObservers(new StateChangeEvent(StateChangeEventType.MOVING, this, y3, y4));
            Utilities.sleep(l2);
        }
        y4 = y2 = y4;
        this.a(y4);
        this.notifyObservers(new StateChangeEvent(StateChangeEventType.END_MOVING, this, y3, y4));
    }

    private void a(Direction object, Direction direction) {
        if (!this.a()) {
            return;
        }
        Intersection intersection = this.getIntersection();
        intersection.removeSim(this);
        Direction direction2 = direction;
        Direction direction3 = object;
        object = this;
        y y2 = super.e();
        y y3 = super.e();
        ((Sim)object).notifyObservers(new StateChangeEvent(StateChangeEventType.BEGIN_TURNING, (Sim)object, y2, y3));
        double d2 = direction3.a();
        double d3 = direction2.a();
        if (direction3 == Direction.NORTH && direction2 == Direction.EAST) {
            d3 = Math.PI * 2;
        } else if (direction3 == Direction.EAST && direction2 == Direction.NORTH) {
            d2 = Math.PI * 2;
        }
        long l2 = (long)(1000.0 / ((Robot)object).c * ((Robot)object).b) / 8L;
        double d4 = (d3 - d2) / 8.0;
        for (int i2 = 0; i2 < 8; ++i2) {
            y2 = y3;
            y3 = new y(y2.a, y2.b, d2 += d4);
            super.a(y3);
            ((Sim)object).notifyObservers(new StateChangeEvent(StateChangeEventType.TURNING, (Sim)object, y2, y3));
            Utilities.sleep(l2);
        }
        y2 = y3;
        y3 = new y(y2.a, y2.b, d3);
        super.a(y3);
        ((Sim)object).notifyObservers(new StateChangeEvent(StateChangeEventType.END_TURNING, (Sim)object, y2, y3));
        this.a = direction;
        intersection.addSim(this);
    }

    final void a(Thing thing) {
        thing.a(this);
        this.e.a(thing);
    }

    synchronized void turnRight() {
        this.a(this.a, this.a.right());
    }

    private boolean a() {
        this.f();
        return !this.d;
    }

    private final class a
    implements IObserver {
        private /* synthetic */ Robot a;

        private a(Robot robot, byte by) {
            this.a = robot;
        }

        public final void update(Object object, Object object2) {
            if (object instanceof ad) {
                object = (ad)object;
                this.a.b = ((ad)object).h();
            }
        }

        /* synthetic */ a(Robot robot) {
            this(robot, 0);
        }
    }
}

