/*
 * Decompiled with CFR 0.152.
 */
package becker.robots;

import becker.util.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Direction
extends Enum<Direction> {
    public static final /* enum */ Direction EAST = new Direction(0);
    public static final /* enum */ Direction SOUTHEAST = new Direction(1);
    public static final /* enum */ Direction SOUTH = new Direction(2);
    public static final /* enum */ Direction SOUTHWEST = new Direction(3);
    public static final /* enum */ Direction WEST = new Direction(4);
    public static final /* enum */ Direction NORTHWEST = new Direction(5);
    public static final /* enum */ Direction NORTH = new Direction(6);
    public static final /* enum */ Direction NORTHEAST = new Direction(7);
    private double a;
    private int b;
    private int c;
    private static final /* synthetic */ Direction[] d;

    public static final Direction[] values() {
        return (Direction[])d.clone();
    }

    public static Direction valueOf(String string) {
        return Enum.valueOf(Direction.class, string);
    }

    private Direction(int n3) {
        assert (n3 >= 0 && n3 < 8);
        this.a = (double)(n3 << 1) * Math.PI / 8.0;
        this.b = (int)Math.round(Math.cos(this.a));
        this.c = (int)Math.round(Math.sin(this.a));
    }

    final double a() {
        return this.a;
    }

    final int b() {
        return this.b;
    }

    final int c() {
        return this.c;
    }

    static Direction a(double d2) {
        int n2 = (int)Math.round((d2 %= Math.PI * 2) / 0.7853981633974483);
        if (n2 < 0 || n2 > 7) {
            throw new ArrayIndexOutOfBoundsException("index = " + n2 + "; angle = " + d2);
        }
        return Direction.values()[n2];
    }

    final boolean d() {
        return this.b == 0 || this.c == 0;
    }

    public final Direction left() {
        switch (this) {
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return WEST;
            }
            case WEST: {
                return SOUTH;
            }
            case SOUTH: {
                return EAST;
            }
        }
        assert (false);
        return null;
    }

    public final Direction right() {
        switch (this) {
            case EAST: {
                return SOUTH;
            }
            case NORTH: {
                return EAST;
            }
            case WEST: {
                return NORTH;
            }
            case SOUTH: {
                return WEST;
            }
        }
        assert (false);
        return null;
    }

    public final Direction opposite() {
        switch (this) {
            case EAST: {
                return WEST;
            }
            case NORTH: {
                return SOUTH;
            }
            case WEST: {
                return EAST;
            }
            case SOUTH: {
                return NORTH;
            }
            case NORTHEAST: {
                return SOUTHWEST;
            }
            case NORTHWEST: {
                return SOUTHEAST;
            }
            case SOUTHWEST: {
                return NORTHEAST;
            }
            case SOUTHEAST: {
                return NORTHWEST;
            }
        }
        assert (false);
        return null;
    }

    public static void main(String[] objectArray) {
        Direction direction = EAST;
        Test.ckEquals("EAST", 1, direction.b);
        direction = EAST;
        Test.ckEquals("EAST", 0, direction.c);
        direction = NORTHEAST;
        Test.ckEquals("NORTHEAST", 1, direction.b);
        direction = NORTHEAST;
        Test.ckEquals("NORTHEAST", -1, direction.c);
        direction = SOUTHEAST;
        Test.ckEquals("SOUTHEAST", 1, direction.b);
        direction = SOUTHEAST;
        Test.ckEquals("SOUTHEAST", 1, direction.c);
        Direction[] directionArray = Direction.values();
        int n2 = directionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Direction direction2;
            direction = direction2 = directionArray[i2];
            Test.ckEquals("mapAngle", (Object)direction2, (Object)Direction.a(direction.a + 1.0E-5));
            direction = direction2;
            Test.ckEquals("mapAngle", (Object)direction2, (Object)Direction.a(direction.a - 1.0E-5));
        }
    }

    static {
        d = new Direction[]{EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST, NORTH, NORTHEAST};
    }
}

