package moreoop;

// this is our Room class so far (after Session 4.1)

public class Room {

    // # of people per square meter standing
    public static double standingLimit = 2;  
    // # of people per square meter sitting
    public static double sittingLimit = .5;

    public String name = "TBD";         // name of room
    public double length = 10;  // room length
    public double width = 10;   // room width

    // default constructor
    public Room() {
        // this must be included 
        // if you initialized your variables, it's empty, which is ok
        // if you didn't initialize variables up above, you 
        // would do that here
    }

    // construct a room with a specific name, and default dimensions
    public Room(String name) {
        this.name = name;
        // if you didn't initialize your variables up above, you 
        // need to include these:
        // this.length = 10;
        // this.width = 10;
    }

    // construct a room with a specific name and dimensions
    public Room(String name, double length, double width) {

        // when params have same name as data members, use "this" to 
        // make it clear which one you are referring to
        this.name = name;
        this.length = length;
        this.width = width;
    }

    // get the area of the room
    public double calculateArea() {
        return length * width;
    }

    // get the perimeter of the room
    public double calculatePerimeter() {
        return length * 2 + width * 2;
    }

    // return a string with this room's information (this is what our 
    // Room "looks like as a string")
    public String displayRoom() {
        return String.format("Room %s: %.1f x %.1f", name, length, width);
    }

    // get the maximum allowed capacity of the room if people are standing
    public int maxStanding() {
        // also fine to say length * width instead of calculateArea()
        // ... in fact, length * width is more efficient, but the downside 
        // is if you had to change the formula, you'd have to edit it 
        // in every place where you said length * width :P
        return (int) (calculateArea() * standingLimit);
    }

    // get the maximum allowed capacity of the room if people are sitting
    public int maxSitting() {
        return (int) (calculateArea() * sittingLimit);
    }
}
