package exceptions;

import java.util.Scanner;

public class ExceptionsIntro {

    public static void main(String[] args) {

        /*
         * Just a quick introduction to how exceptions work.
         * We'll learn more about exceptions throughout the course.
         * 
         * Exception = error, exceptional circumstance.
         * Exceptions are OBJECTS: there are many Exception classes.
         * 
         * When an error occurs, an Exception class is instantiated,
         * and the exception object is THROWN.
         * 
         * Exception handling = writing code that deals with
         * exceptions. You'll learn exception handling in an upcoming
         * lesson. In this lesson you only learn how exceptions work.
         * 
         * If you have no exception handlers, exception obects that are
         * thrown will travel up the call stack to the main()
         * method. In the main(), the program will terminate on the
         * statement that threw the exception.
         * This causes a STACK TRACE to appear in the console/terminal.
         * 
         * NOTE for those who have used a try-catch before:
         * The exceptions we are encountering so far are "unchecked"
         * exceptions. You should NEVER use a try-catch for an
         * unchecked exception. If you have no idea what a try-catch
         * is yet, then you can ignore this paragraph.
         */

        // these methods are pointless and for demo only
        doInputThings();
        doStringExample(); // to test this, easier to comment out doInputThings()

    }

    // this method serves no purpose at all other than to
    // demonstrate how an exception is thrown
    public static void doInputThings() {

        Scanner input = new Scanner(System.in);

        // to see what happens if you type something that the scanner
        // can't convert into an integer
        System.out.print("Type something that's not a valid int: ");
        int number = input.nextInt();

        System.out.println(number);

        double value = getDoubleValue(input);
        System.out.println(value);

        input.close();
    }

    public static double getDoubleValue(Scanner scan) {

        // to see what happens when the user enters something
        // that can't be parsed into a double
        System.out.print("Enter something that's not a valid double: ");
        String str = scan.next();
        double num = Double.parseDouble(str);

        return num;
    }

    public static void doStringExample() {
        Scanner input = new Scanner(System.in);
        String example = getString(input);
        System.out.println(example.length());
        input.close();
    }

    public static String getString(Scanner scan) {
        System.out.print("Give me a string.");
        String str = scan.nextLine();
        if (str.length() > 0) {
            return str;
        } else {
            return null;
        }        
    }

}
